﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml.Linq;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Customers
{
    public partial class EditCustomer : System.Web.UI.Page
    {
        private UserAccount currAccount;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindCountry();
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdUserAccountID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowCustomerDetails();
                }
            }
        }

        private void BindCountry()
        {

            var doc = XDocument.Load(Server.MapPath("~/Resources/countries.xml"));
            var countries = from c in doc.Descendants("country")
                            select c.Value;
            ddlCountry.DataSource = countries;
            ddlCountry.DataBind();

            ddlCountry.DataSource = countries;
            ddlCountry.DataBind();

            ddlCountry.Items.FindByText("Singapore").Selected = true;

        }

        private void ShowCustomerDetails()
        {
            currAccount = UserAccountBL.GetItem(Guid.Parse(hdUserAccountID.Value.Trim()), string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            if (currAccount != null)
            {
                hdUserAccountID.Value = currAccount.UniqueID.ToString();
                //txtUserName.Text = currAccount.UserName;
                //txtPassword.Attributes["value"] = ValidationUtility.DecryptPassword(currAccount.UPassword);
                ddlSalutation.SelectedIndex = ddlSalutation.Items.IndexOf(ddlSalutation.Items.FindByValue(currAccount.Salutation));
                txtFirstName.Text = currAccount.FirstName;
                txtLastName.Text = currAccount.LastName;
                ddlGender.SelectedIndex = ddlGender.Items.IndexOf(ddlGender.Items.FindByValue(currAccount.Gender));
                txtEmail.Text = currAccount.Email;
                txtMobileNo.Text = currAccount.MobileNo;
                txtPhoneNo.Text = currAccount.PhoneNo;
                txtDOB.Text = currAccount.DOB != DateTime.MinValue ? currAccount.DOB.ToString("dd/MM/yyyy") : string.Empty;
                txtAddress1.Text = currAccount.Address1;
                txtAddress2.Text = currAccount.Address2;
                txtCity.Text = currAccount.City;
                txtState.Text = currAccount.StateProvince;
                ddlCountry.SelectedIndex = ddlCountry.Items.IndexOf(ddlCountry.Items.FindByText(currAccount.Country));
                txtPostalCode.Text = currAccount.PostalCode;
                ddlCustomerType.SelectedIndex = ddlCustomerType.Items.IndexOf(ddlCustomerType.Items.FindByValue(currAccount.CustomerType));
                ddlDiscountType.SelectedIndex = ddlDiscountType.Items.IndexOf(ddlDiscountType.Items.FindByValue(currAccount.DiscountType));
                txtDiscountValue.Text = currAccount.DiscountValue.ToString("0.00");
                chkIsApproved.Checked = currAccount.IsApproved;
                chkIsSubscribed.Checked = currAccount.IsSubscribed;
                chkIsActive.Checked = currAccount.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            //string password = txtPassword.Text.Trim();
            if (ValidatePageValue())
            {
                currAccount = new UserAccount();
                if (hdUserAccountID.Value.Trim().Length == 0)
                    currAccount.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    currAccount.Mode = GlobalConfigurations.Mode.Update;
                    currAccount.UniqueID = Guid.Parse(hdUserAccountID.Value.Trim());
                }

                //currAccount.UserName = txtUserName.Text.Trim();
                currAccount.UserName = currAccount.Email = txtEmail.Text.Trim();
                //currAccount.UPassword = ValidationUtility.EncryptPassword(txtPassword.Text.Trim());
                currAccount.UPassword = ValidationUtility.EncryptPassword("123456");
                currAccount.Salutation = ddlSalutation.SelectedValue != "0" ? ddlSalutation.SelectedValue : string.Empty;
                currAccount.FirstName = txtFirstName.Text.Trim();
                currAccount.LastName = txtLastName.Text.Trim();
                currAccount.Gender = ddlGender.SelectedValue != "0" ? ddlGender.SelectedValue : string.Empty;

                currAccount.MobileNo = txtMobileNo.Text.Trim();
                currAccount.PhoneNo = txtPhoneNo.Text.Trim();
                currAccount.DOB = txtDOB.Text.Trim().Length != 0 ? DateTime.ParseExact(txtDOB.Text.Trim(), "dd/MM/yyyy", null) : DateTime.MinValue;
                currAccount.Address1 = txtAddress1.Text.Trim();
                currAccount.Address2 = txtAddress2.Text.Trim();
                currAccount.City = txtCity.Text.Trim();
                currAccount.StateProvince = txtState.Text.Trim();
                currAccount.Country = ddlCountry.SelectedValue != "0" ? ddlCountry.SelectedItem.Text : string.Empty;
                currAccount.PostalCode = txtPostalCode.Text.Trim();
                currAccount.CustomerType = ddlCustomerType.SelectedValue != "0" ? ddlCustomerType.SelectedValue : string.Empty;
                currAccount.DiscountType = ddlDiscountType.SelectedValue != "0" ? ddlDiscountType.SelectedValue : string.Empty;
                currAccount.DiscountValue = txtDiscountValue.Text.Trim().Length != 0 ? decimal.Parse(txtDiscountValue.Text.Trim()) : 0;
                currAccount.UserRoleType = "User";
                currAccount.IsApproved = chkIsApproved.Checked;
                currAccount.IsSubscribed = chkIsSubscribed.Checked;
                currAccount.IsActive = chkIsActive.Checked;
                currAccount.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (UserAccountBL.Save(currAccount))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Customer details has been saved successfully.<br>Do you want to add another Customer?", this.ResolveClientUrl("~/Admin/Customers/Customers.aspx"));
                }
            }
            else
            {
                //txtPassword.Attributes["value"] = password;
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Customers/Customers.aspx", false);
        }

        private bool ValidatePageValue()
        {
            //if (!ValidationUtility.ValidateString(txtUserName.Text.Trim()))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtUserName.ClientID + "', 'Please enter valid User Name.'); ", true);
            //    return false;
            //}

            //if (!ValidationUtility.ValidateString(txtPassword.Text.Trim()))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtPassword.ClientID + "', 'Please enter valid Password.'); ", true);
            //    return false;
            //}

            if (!ValidationUtility.ValidateString(txtFirstName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtFirstName.ClientID + "', 'Please enter valid First Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateString(txtLastName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtLastName.ClientID + "', 'Please enter valid Last Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateEmail(txtEmail.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtEmail.ClientID + "', 'Please enter valid Email.'); ", true);
                return false;
            }


            if (ValidationUtility.ValidateString(txtDOB.Text.Trim()) && !ValidationUtility.ValidateDate(txtDOB.Text.Trim(), "dd/MM/yyyy"))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtDOB.ClientID + "', 'Please enter valid DOB.'); ", true);
                return false;
            }

            if (ddlCustomerType.SelectedValue.Equals("0"))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + ddlCustomerType.ClientID + "', 'Please select Customer Type.'); ", true);
                return false;
            }


            if (ValidationUtility.ValidateString(txtDiscountValue.Text.Trim()))
            {
                if (!ValidationUtility.ValidateDecimal(txtDiscountValue.Text.Trim()))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtDiscountValue.ClientID + "', 'Please enter valid Discount Value.'); ", true);
                    return false;
                }
            }

            return true;
        }
    }
}